// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ElasticSan
{
    internal class ElasticSanPrivateEndpointConnectionOperationSource : IOperationSource<ElasticSanPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal ElasticSanPrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        ElasticSanPrivateEndpointConnectionResource IOperationSource<ElasticSanPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ElasticSanPrivateEndpointConnectionData.DeserializeElasticSanPrivateEndpointConnectionData(document.RootElement);
            return new ElasticSanPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<ElasticSanPrivateEndpointConnectionResource> IOperationSource<ElasticSanPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ElasticSanPrivateEndpointConnectionData.DeserializeElasticSanPrivateEndpointConnectionData(document.RootElement);
            return new ElasticSanPrivateEndpointConnectionResource(_client, data);
        }
    }
}
