// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ElasticSan.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableElasticSanResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableElasticSanResourceGroupResource"/> class for mocking. </summary>
        protected MockableElasticSanResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableElasticSanResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableElasticSanResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of ElasticSanResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of ElasticSanResources and their operations over a ElasticSanResource. </returns>
        public virtual ElasticSanCollection GetElasticSans()
        {
            return GetCachedClient(client => new ElasticSanCollection(client, Id));
        }

        /// <summary>
        /// Get a ElasticSan.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ElasticSans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ElasticSanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="elasticSanName"> The name of the ElasticSan. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="elasticSanName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="elasticSanName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<ElasticSanResource>> GetElasticSanAsync(string elasticSanName, CancellationToken cancellationToken = default)
        {
            return await GetElasticSans().GetAsync(elasticSanName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a ElasticSan.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ElasticSans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ElasticSanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="elasticSanName"> The name of the ElasticSan. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="elasticSanName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="elasticSanName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<ElasticSanResource> GetElasticSan(string elasticSanName, CancellationToken cancellationToken = default)
        {
            return GetElasticSans().Get(elasticSanName, cancellationToken);
        }
    }
}
