// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.ElasticSan.Models;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.ElasticSan
{
    /// <summary>
    /// A class representing the ElasticSanPrivateEndpointConnection data model.
    ///  Response for PrivateEndpoint Connection object
    /// </summary>
    public partial class ElasticSanPrivateEndpointConnectionData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ElasticSanPrivateEndpointConnectionData"/>. </summary>
        /// <param name="connectionState"> Private Link Service Connection State. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectionState"/> is null. </exception>
        public ElasticSanPrivateEndpointConnectionData(ElasticSanPrivateLinkServiceConnectionState connectionState)
        {
            Argument.AssertNotNull(connectionState, nameof(connectionState));

            ConnectionState = connectionState;
            GroupIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ElasticSanPrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Provisioning State of Private Endpoint connection resource. </param>
        /// <param name="privateEndpoint"> Private Endpoint resource. </param>
        /// <param name="connectionState"> Private Link Service Connection State. </param>
        /// <param name="groupIds"> List of resources private endpoint is mapped. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ElasticSanPrivateEndpointConnectionData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ElasticSanProvisioningState? provisioningState, SubResource privateEndpoint, ElasticSanPrivateLinkServiceConnectionState connectionState, IList<string> groupIds, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            PrivateEndpoint = privateEndpoint;
            ConnectionState = connectionState;
            GroupIds = groupIds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ElasticSanPrivateEndpointConnectionData"/> for deserialization. </summary>
        internal ElasticSanPrivateEndpointConnectionData()
        {
        }

        /// <summary> Provisioning State of Private Endpoint connection resource. </summary>
        public ElasticSanProvisioningState? ProvisioningState { get; }
        /// <summary> Private Endpoint resource. </summary>
        internal SubResource PrivateEndpoint { get; set; }
        /// <summary> Gets Id. </summary>
        public ResourceIdentifier PrivateEndpointId
        {
            get => PrivateEndpoint is null ? default : PrivateEndpoint.Id;
        }

        /// <summary> Private Link Service Connection State. </summary>
        public ElasticSanPrivateLinkServiceConnectionState ConnectionState { get; set; }
        /// <summary> List of resources private endpoint is mapped. </summary>
        public IList<string> GroupIds { get; }
    }
}
