// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.ElasticSan.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ElasticSan
{
    public partial class ElasticSanData : IUtf8JsonSerializable, IJsonModel<ElasticSanData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ElasticSanData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ElasticSanData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ElasticSanData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ElasticSanData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            writer.WritePropertyName("sku"u8);
            writer.WriteObjectValue(Sku, options);
            if (Optional.IsCollectionDefined(AvailabilityZones))
            {
                writer.WritePropertyName("availabilityZones"u8);
                writer.WriteStartArray();
                foreach (var item in AvailabilityZones)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            writer.WritePropertyName("baseSizeTiB"u8);
            writer.WriteNumberValue(BaseSizeTiB);
            writer.WritePropertyName("extendedCapacitySizeTiB"u8);
            writer.WriteNumberValue(ExtendedCapacitySizeTiB);
            if (options.Format != "W" && Optional.IsDefined(TotalVolumeSizeGiB))
            {
                writer.WritePropertyName("totalVolumeSizeGiB"u8);
                writer.WriteNumberValue(TotalVolumeSizeGiB.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(VolumeGroupCount))
            {
                writer.WritePropertyName("volumeGroupCount"u8);
                writer.WriteNumberValue(VolumeGroupCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalIops))
            {
                writer.WritePropertyName("totalIops"u8);
                writer.WriteNumberValue(TotalIops.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalMbps))
            {
                writer.WritePropertyName("totalMBps"u8);
                writer.WriteNumberValue(TotalMbps.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalSizeTiB))
            {
                writer.WritePropertyName("totalSizeTiB"u8);
                writer.WriteNumberValue(TotalSizeTiB.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(PrivateEndpointConnections))
            {
                writer.WritePropertyName("privateEndpointConnections"u8);
                writer.WriteStartArray();
                foreach (var item in PrivateEndpointConnections)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(PublicNetworkAccess))
            {
                writer.WritePropertyName("publicNetworkAccess"u8);
                writer.WriteStringValue(PublicNetworkAccess.Value.ToString());
            }
            if (Optional.IsDefined(AutoScaleProperties))
            {
                writer.WritePropertyName("autoScaleProperties"u8);
                writer.WriteObjectValue(AutoScaleProperties, options);
            }
            writer.WriteEndObject();
        }

        ElasticSanData IJsonModel<ElasticSanData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ElasticSanData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ElasticSanData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeElasticSanData(document.RootElement, options);
        }

        internal static ElasticSanData DeserializeElasticSanData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            ElasticSanSku sku = default;
            IList<string> availabilityZones = default;
            ElasticSanProvisioningState? provisioningState = default;
            long baseSizeTiB = default;
            long extendedCapacitySizeTiB = default;
            long? totalVolumeSizeGiB = default;
            long? volumeGroupCount = default;
            long? totalIops = default;
            long? totalMbps = default;
            long? totalSizeTiB = default;
            IReadOnlyList<ElasticSanPrivateEndpointConnectionData> privateEndpointConnections = default;
            ElasticSanPublicNetworkAccess? publicNetworkAccess = default;
            AutoScaleProperties autoScaleProperties = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("sku"u8))
                        {
                            sku = ElasticSanSku.DeserializeElasticSanSku(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("availabilityZones"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            availabilityZones = array;
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new ElasticSanProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("baseSizeTiB"u8))
                        {
                            baseSizeTiB = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("extendedCapacitySizeTiB"u8))
                        {
                            extendedCapacitySizeTiB = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("totalVolumeSizeGiB"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            totalVolumeSizeGiB = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("volumeGroupCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            volumeGroupCount = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("totalIops"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            totalIops = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("totalMBps"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            totalMbps = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("totalSizeTiB"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            totalSizeTiB = property0.Value.GetInt64();
                            continue;
                        }
                        if (property0.NameEquals("privateEndpointConnections"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ElasticSanPrivateEndpointConnectionData> array = new List<ElasticSanPrivateEndpointConnectionData>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ElasticSanPrivateEndpointConnectionData.DeserializeElasticSanPrivateEndpointConnectionData(item, options));
                            }
                            privateEndpointConnections = array;
                            continue;
                        }
                        if (property0.NameEquals("publicNetworkAccess"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            publicNetworkAccess = new ElasticSanPublicNetworkAccess(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("autoScaleProperties"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            autoScaleProperties = AutoScaleProperties.DeserializeAutoScaleProperties(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ElasticSanData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                sku,
                availabilityZones ?? new ChangeTrackingList<string>(),
                provisioningState,
                baseSizeTiB,
                extendedCapacitySizeTiB,
                totalVolumeSizeGiB,
                volumeGroupCount,
                totalIops,
                totalMbps,
                totalSizeTiB,
                privateEndpointConnections ?? new ChangeTrackingList<ElasticSanPrivateEndpointConnectionData>(),
                publicNetworkAccess,
                autoScaleProperties,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ElasticSanData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ElasticSanData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ElasticSanData)} does not support writing '{options.Format}' format.");
            }
        }

        ElasticSanData IPersistableModel<ElasticSanData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ElasticSanData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeElasticSanData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ElasticSanData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ElasticSanData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
