// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Elastic
{
    /// <summary>
    /// A class representing a collection of <see cref="OpenAIIntegrationRPModelResource"/> and their operations.
    /// Each <see cref="OpenAIIntegrationRPModelResource"/> in the collection will belong to the same instance of <see cref="ElasticMonitorResource"/>.
    /// To get an <see cref="OpenAIIntegrationRPModelCollection"/> instance call the GetOpenAIIntegrationRPModels method from an instance of <see cref="ElasticMonitorResource"/>.
    /// </summary>
    public partial class OpenAIIntegrationRPModelCollection : ArmCollection, IEnumerable<OpenAIIntegrationRPModelResource>, IAsyncEnumerable<OpenAIIntegrationRPModelResource>
    {
        private readonly ClientDiagnostics _openAIIntegrationRPModelOpenAIClientDiagnostics;
        private readonly OpenAIRestOperations _openAIIntegrationRPModelOpenAIRestClient;

        /// <summary> Initializes a new instance of the <see cref="OpenAIIntegrationRPModelCollection"/> class for mocking. </summary>
        protected OpenAIIntegrationRPModelCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="OpenAIIntegrationRPModelCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal OpenAIIntegrationRPModelCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _openAIIntegrationRPModelOpenAIClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Elastic", OpenAIIntegrationRPModelResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(OpenAIIntegrationRPModelResource.ResourceType, out string openAIIntegrationRPModelOpenAIApiVersion);
            _openAIIntegrationRPModelOpenAIRestClient = new OpenAIRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, openAIIntegrationRPModelOpenAIApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ElasticMonitorResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ElasticMonitorResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create or update a OpenAI integration rule for a given monitor resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Elastic/monitors/{monitorName}/openAIIntegrations/{integrationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OpenAI_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-15-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OpenAIIntegrationRPModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="integrationName"> OpenAI Integration name. </param>
        /// <param name="data"> The <see cref="OpenAIIntegrationRPModelData"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="integrationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="integrationName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<OpenAIIntegrationRPModelResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string integrationName, OpenAIIntegrationRPModelData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(integrationName, nameof(integrationName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _openAIIntegrationRPModelOpenAIClientDiagnostics.CreateScope("OpenAIIntegrationRPModelCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _openAIIntegrationRPModelOpenAIRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, integrationName, data, cancellationToken).ConfigureAwait(false);
                var uri = _openAIIntegrationRPModelOpenAIRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, integrationName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ElasticArmOperation<OpenAIIntegrationRPModelResource>(Response.FromValue(new OpenAIIntegrationRPModelResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create or update a OpenAI integration rule for a given monitor resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Elastic/monitors/{monitorName}/openAIIntegrations/{integrationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OpenAI_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-15-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OpenAIIntegrationRPModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="integrationName"> OpenAI Integration name. </param>
        /// <param name="data"> The <see cref="OpenAIIntegrationRPModelData"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="integrationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="integrationName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<OpenAIIntegrationRPModelResource> CreateOrUpdate(WaitUntil waitUntil, string integrationName, OpenAIIntegrationRPModelData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(integrationName, nameof(integrationName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _openAIIntegrationRPModelOpenAIClientDiagnostics.CreateScope("OpenAIIntegrationRPModelCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _openAIIntegrationRPModelOpenAIRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, integrationName, data, cancellationToken);
                var uri = _openAIIntegrationRPModelOpenAIRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, integrationName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ElasticArmOperation<OpenAIIntegrationRPModelResource>(Response.FromValue(new OpenAIIntegrationRPModelResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get OpenAI integration rule for a given monitor resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Elastic/monitors/{monitorName}/openAIIntegrations/{integrationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OpenAI_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-15-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OpenAIIntegrationRPModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="integrationName"> OpenAI Integration name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="integrationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="integrationName"/> is null. </exception>
        public virtual async Task<Response<OpenAIIntegrationRPModelResource>> GetAsync(string integrationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(integrationName, nameof(integrationName));

            using var scope = _openAIIntegrationRPModelOpenAIClientDiagnostics.CreateScope("OpenAIIntegrationRPModelCollection.Get");
            scope.Start();
            try
            {
                var response = await _openAIIntegrationRPModelOpenAIRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, integrationName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OpenAIIntegrationRPModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get OpenAI integration rule for a given monitor resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Elastic/monitors/{monitorName}/openAIIntegrations/{integrationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OpenAI_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-15-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OpenAIIntegrationRPModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="integrationName"> OpenAI Integration name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="integrationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="integrationName"/> is null. </exception>
        public virtual Response<OpenAIIntegrationRPModelResource> Get(string integrationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(integrationName, nameof(integrationName));

            using var scope = _openAIIntegrationRPModelOpenAIClientDiagnostics.CreateScope("OpenAIIntegrationRPModelCollection.Get");
            scope.Start();
            try
            {
                var response = _openAIIntegrationRPModelOpenAIRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, integrationName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new OpenAIIntegrationRPModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List OpenAI integration rule for a given monitor resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Elastic/monitors/{monitorName}/openAIIntegrations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OpenAI_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-15-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OpenAIIntegrationRPModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="OpenAIIntegrationRPModelResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<OpenAIIntegrationRPModelResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _openAIIntegrationRPModelOpenAIRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _openAIIntegrationRPModelOpenAIRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new OpenAIIntegrationRPModelResource(Client, OpenAIIntegrationRPModelData.DeserializeOpenAIIntegrationRPModelData(e)), _openAIIntegrationRPModelOpenAIClientDiagnostics, Pipeline, "OpenAIIntegrationRPModelCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List OpenAI integration rule for a given monitor resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Elastic/monitors/{monitorName}/openAIIntegrations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OpenAI_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-15-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OpenAIIntegrationRPModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="OpenAIIntegrationRPModelResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<OpenAIIntegrationRPModelResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _openAIIntegrationRPModelOpenAIRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _openAIIntegrationRPModelOpenAIRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new OpenAIIntegrationRPModelResource(Client, OpenAIIntegrationRPModelData.DeserializeOpenAIIntegrationRPModelData(e)), _openAIIntegrationRPModelOpenAIClientDiagnostics, Pipeline, "OpenAIIntegrationRPModelCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Elastic/monitors/{monitorName}/openAIIntegrations/{integrationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OpenAI_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-15-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OpenAIIntegrationRPModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="integrationName"> OpenAI Integration name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="integrationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="integrationName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string integrationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(integrationName, nameof(integrationName));

            using var scope = _openAIIntegrationRPModelOpenAIClientDiagnostics.CreateScope("OpenAIIntegrationRPModelCollection.Exists");
            scope.Start();
            try
            {
                var response = await _openAIIntegrationRPModelOpenAIRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, integrationName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Elastic/monitors/{monitorName}/openAIIntegrations/{integrationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OpenAI_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-15-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OpenAIIntegrationRPModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="integrationName"> OpenAI Integration name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="integrationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="integrationName"/> is null. </exception>
        public virtual Response<bool> Exists(string integrationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(integrationName, nameof(integrationName));

            using var scope = _openAIIntegrationRPModelOpenAIClientDiagnostics.CreateScope("OpenAIIntegrationRPModelCollection.Exists");
            scope.Start();
            try
            {
                var response = _openAIIntegrationRPModelOpenAIRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, integrationName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Elastic/monitors/{monitorName}/openAIIntegrations/{integrationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OpenAI_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-15-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OpenAIIntegrationRPModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="integrationName"> OpenAI Integration name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="integrationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="integrationName"/> is null. </exception>
        public virtual async Task<NullableResponse<OpenAIIntegrationRPModelResource>> GetIfExistsAsync(string integrationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(integrationName, nameof(integrationName));

            using var scope = _openAIIntegrationRPModelOpenAIClientDiagnostics.CreateScope("OpenAIIntegrationRPModelCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _openAIIntegrationRPModelOpenAIRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, integrationName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<OpenAIIntegrationRPModelResource>(response.GetRawResponse());
                return Response.FromValue(new OpenAIIntegrationRPModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Elastic/monitors/{monitorName}/openAIIntegrations/{integrationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OpenAI_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-06-15-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="OpenAIIntegrationRPModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="integrationName"> OpenAI Integration name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="integrationName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="integrationName"/> is null. </exception>
        public virtual NullableResponse<OpenAIIntegrationRPModelResource> GetIfExists(string integrationName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(integrationName, nameof(integrationName));

            using var scope = _openAIIntegrationRPModelOpenAIClientDiagnostics.CreateScope("OpenAIIntegrationRPModelCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _openAIIntegrationRPModelOpenAIRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, integrationName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<OpenAIIntegrationRPModelResource>(response.GetRawResponse());
                return Response.FromValue(new OpenAIIntegrationRPModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<OpenAIIntegrationRPModelResource> IEnumerable<OpenAIIntegrationRPModelResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<OpenAIIntegrationRPModelResource> IAsyncEnumerable<OpenAIIntegrationRPModelResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
