// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Elastic.Models
{
    /// <summary> The vm ingestion details to install an agent. </summary>
    public partial class VmIngestionDetailsResponse
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VmIngestionDetailsResponse"/>. </summary>
        internal VmIngestionDetailsResponse()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VmIngestionDetailsResponse"/>. </summary>
        /// <param name="cloudId"> The cloudId of given Elastic monitor resource. </param>
        /// <param name="ingestionKey"> Ingestion details to install agent on given VM. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VmIngestionDetailsResponse(string cloudId, string ingestionKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CloudId = cloudId;
            IngestionKey = ingestionKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The cloudId of given Elastic monitor resource. </summary>
        public string CloudId { get; }
        /// <summary> Ingestion details to install agent on given VM. </summary>
        public string IngestionKey { get; }
    }
}
