// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Elastic.Models
{
    /// <summary> Update VM resource collection. </summary>
    public partial class VmCollectionUpdate
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VmCollectionUpdate"/>. </summary>
        public VmCollectionUpdate()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VmCollectionUpdate"/>. </summary>
        /// <param name="vmResourceId"> ARM id of the VM resource. </param>
        /// <param name="operationName"> Operation to be performed for given VM. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VmCollectionUpdate(string vmResourceId, OperationName? operationName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VmResourceId = vmResourceId;
            OperationName = operationName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> ARM id of the VM resource. </summary>
        public string VmResourceId { get; set; }
        /// <summary> Operation to be performed for given VM. </summary>
        public OperationName? OperationName { get; set; }
    }
}
