// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Elastic.Models
{
    /// <summary> User Information to be passed to partners. </summary>
    public partial class UserInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UserInfo"/>. </summary>
        public UserInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="UserInfo"/>. </summary>
        /// <param name="firstName"> First name of the user. </param>
        /// <param name="lastName"> Last name of the user. </param>
        /// <param name="companyName"> Company name of the user. </param>
        /// <param name="emailAddress"> Email of the user used by Elastic for contacting them if needed. </param>
        /// <param name="companyInfo"> Company information of the user to be passed to partners. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UserInfo(string firstName, string lastName, string companyName, string emailAddress, CompanyInfo companyInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FirstName = firstName;
            LastName = lastName;
            CompanyName = companyName;
            EmailAddress = emailAddress;
            CompanyInfo = companyInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> First name of the user. </summary>
        public string FirstName { get; set; }
        /// <summary> Last name of the user. </summary>
        public string LastName { get; set; }
        /// <summary> Company name of the user. </summary>
        public string CompanyName { get; set; }
        /// <summary> Email of the user used by Elastic for contacting them if needed. </summary>
        public string EmailAddress { get; set; }
        /// <summary> Company information of the user to be passed to partners. </summary>
        public CompanyInfo CompanyInfo { get; set; }
    }
}
