// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Elastic.Models
{
    /// <summary> Stack Versions that this version can upgrade to. </summary>
    public partial class UpgradableVersionsList
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UpgradableVersionsList"/>. </summary>
        internal UpgradableVersionsList()
        {
            UpgradableVersions = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="UpgradableVersionsList"/>. </summary>
        /// <param name="currentVersion"> Current version of the elastic monitor. </param>
        /// <param name="upgradableVersions"> Stack Versions that this version can upgrade to. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UpgradableVersionsList(string currentVersion, IReadOnlyList<string> upgradableVersions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CurrentVersion = currentVersion;
            UpgradableVersions = upgradableVersions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Current version of the elastic monitor. </summary>
        public string CurrentVersion { get; }
        /// <summary> Stack Versions that this version can upgrade to. </summary>
        public IReadOnlyList<string> UpgradableVersions { get; }
    }
}
