// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Elastic.Models
{
    /// <summary> Resubscribe Properties. </summary>
    public partial class ResubscribeProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResubscribeProperties"/>. </summary>
        public ResubscribeProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResubscribeProperties"/>. </summary>
        /// <param name="planId"> Newly selected plan Id to create the new Marketplace subscription for Resubscribe. </param>
        /// <param name="term"> Newly selected term to create the new Marketplace subscription for Resubscribe. </param>
        /// <param name="subscriptionId"> Newly selected Azure Subscription Id in which the new Marketplace subscription will be created for Resubscribe. </param>
        /// <param name="resourceGroup"> Newly selected Azure resource group in which the new Marketplace subscription will be created for Resubscribe. </param>
        /// <param name="organizationId"> Organization Id of the Elastic Organization that needs to be resubscribed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResubscribeProperties(string planId, string term, string subscriptionId, string resourceGroup, string organizationId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PlanId = planId;
            Term = term;
            SubscriptionId = subscriptionId;
            ResourceGroup = resourceGroup;
            OrganizationId = organizationId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Newly selected plan Id to create the new Marketplace subscription for Resubscribe. </summary>
        public string PlanId { get; set; }
        /// <summary> Newly selected term to create the new Marketplace subscription for Resubscribe. </summary>
        public string Term { get; set; }
        /// <summary> Newly selected Azure Subscription Id in which the new Marketplace subscription will be created for Resubscribe. </summary>
        public string SubscriptionId { get; set; }
        /// <summary> Newly selected Azure resource group in which the new Marketplace subscription will be created for Resubscribe. </summary>
        public string ResourceGroup { get; set; }
        /// <summary> Organization Id of the Elastic Organization that needs to be resubscribed. </summary>
        public string OrganizationId { get; set; }
    }
}
