// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Elastic.Models
{
    public partial class PlanDetails : IUtf8JsonSerializable, IJsonModel<PlanDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PlanDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PlanDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PlanDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PlanDetails)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(OfferId))
            {
                writer.WritePropertyName("offerID"u8);
                writer.WriteStringValue(OfferId);
            }
            if (Optional.IsDefined(PublisherId))
            {
                writer.WritePropertyName("publisherID"u8);
                writer.WriteStringValue(PublisherId);
            }
            if (Optional.IsDefined(TermId))
            {
                writer.WritePropertyName("termID"u8);
                writer.WriteStringValue(TermId);
            }
            if (Optional.IsDefined(PlanId))
            {
                writer.WritePropertyName("planID"u8);
                writer.WriteStringValue(PlanId);
            }
            if (Optional.IsDefined(PlanName))
            {
                writer.WritePropertyName("planName"u8);
                writer.WriteStringValue(PlanName);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PlanDetails IJsonModel<PlanDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PlanDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PlanDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePlanDetails(document.RootElement, options);
        }

        internal static PlanDetails DeserializePlanDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string offerId = default;
            string publisherId = default;
            string termId = default;
            string planId = default;
            string planName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("offerID"u8))
                {
                    offerId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("publisherID"u8))
                {
                    publisherId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("termID"u8))
                {
                    termId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("planID"u8))
                {
                    planId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("planName"u8))
                {
                    planName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PlanDetails(
                offerId,
                publisherId,
                termId,
                planId,
                planName,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PlanDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PlanDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PlanDetails)} does not support writing '{options.Format}' format.");
            }
        }

        PlanDetails IPersistableModel<PlanDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PlanDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePlanDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PlanDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PlanDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
