// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Elastic.Models
{
    /// <summary> Operation to be performed on the given vm resource id. </summary>
    public readonly partial struct OperationName : IEquatable<OperationName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OperationName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OperationName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AddValue = "Add";
        private const string DeleteValue = "Delete";

        /// <summary> Add. </summary>
        public static OperationName Add { get; } = new OperationName(AddValue);
        /// <summary> Delete. </summary>
        public static OperationName Delete { get; } = new OperationName(DeleteValue);
        /// <summary> Determines if two <see cref="OperationName"/> values are the same. </summary>
        public static bool operator ==(OperationName left, OperationName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OperationName"/> values are not the same. </summary>
        public static bool operator !=(OperationName left, OperationName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OperationName"/>. </summary>
        public static implicit operator OperationName(string value) => new OperationName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OperationName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OperationName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
