// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Elastic.Models
{
    /// <summary> Open AI Integration details. </summary>
    public partial class OpenAIIntegrationProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OpenAIIntegrationProperties"/>. </summary>
        public OpenAIIntegrationProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="OpenAIIntegrationProperties"/>. </summary>
        /// <param name="openAIResourceId"> The resource name of Open AI resource. </param>
        /// <param name="openAIResourceEndpoint"> The API endpoint for Open AI resource. </param>
        /// <param name="openAIConnectorId"> The connector id of Open AI resource. </param>
        /// <param name="key"> Value of API key for Open AI resource. </param>
        /// <param name="lastRefreshOn"> Last Update Timestamp for key updation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OpenAIIntegrationProperties(string openAIResourceId, string openAIResourceEndpoint, string openAIConnectorId, string key, DateTimeOffset? lastRefreshOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OpenAIResourceId = openAIResourceId;
            OpenAIResourceEndpoint = openAIResourceEndpoint;
            OpenAIConnectorId = openAIConnectorId;
            Key = key;
            LastRefreshOn = lastRefreshOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The resource name of Open AI resource. </summary>
        public string OpenAIResourceId { get; set; }
        /// <summary> The API endpoint for Open AI resource. </summary>
        public string OpenAIResourceEndpoint { get; set; }
        /// <summary> The connector id of Open AI resource. </summary>
        public string OpenAIConnectorId { get; set; }
        /// <summary> Value of API key for Open AI resource. </summary>
        public string Key { get; set; }
        /// <summary> Last Update Timestamp for key updation. </summary>
        public DateTimeOffset? LastRefreshOn { get; }
    }
}
