// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Elastic.Models
{
    public partial class OpenAIIntegrationProperties : IUtf8JsonSerializable, IJsonModel<OpenAIIntegrationProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<OpenAIIntegrationProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<OpenAIIntegrationProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OpenAIIntegrationProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OpenAIIntegrationProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(OpenAIResourceId))
            {
                writer.WritePropertyName("openAIResourceId"u8);
                writer.WriteStringValue(OpenAIResourceId);
            }
            if (Optional.IsDefined(OpenAIResourceEndpoint))
            {
                writer.WritePropertyName("openAIResourceEndpoint"u8);
                writer.WriteStringValue(OpenAIResourceEndpoint);
            }
            if (Optional.IsDefined(OpenAIConnectorId))
            {
                writer.WritePropertyName("openAIConnectorId"u8);
                writer.WriteStringValue(OpenAIConnectorId);
            }
            if (Optional.IsDefined(Key))
            {
                writer.WritePropertyName("key"u8);
                writer.WriteStringValue(Key);
            }
            if (options.Format != "W" && Optional.IsDefined(LastRefreshOn))
            {
                writer.WritePropertyName("lastRefreshAt"u8);
                writer.WriteStringValue(LastRefreshOn.Value, "O");
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        OpenAIIntegrationProperties IJsonModel<OpenAIIntegrationProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OpenAIIntegrationProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OpenAIIntegrationProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeOpenAIIntegrationProperties(document.RootElement, options);
        }

        internal static OpenAIIntegrationProperties DeserializeOpenAIIntegrationProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string openAIResourceId = default;
            string openAIResourceEndpoint = default;
            string openAIConnectorId = default;
            string key = default;
            DateTimeOffset? lastRefreshAt = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("openAIResourceId"u8))
                {
                    openAIResourceId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("openAIResourceEndpoint"u8))
                {
                    openAIResourceEndpoint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("openAIConnectorId"u8))
                {
                    openAIConnectorId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("key"u8))
                {
                    key = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastRefreshAt"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastRefreshAt = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new OpenAIIntegrationProperties(
                openAIResourceId,
                openAIResourceEndpoint,
                openAIConnectorId,
                key,
                lastRefreshAt,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<OpenAIIntegrationProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OpenAIIntegrationProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(OpenAIIntegrationProperties)} does not support writing '{options.Format}' format.");
            }
        }

        OpenAIIntegrationProperties IPersistableModel<OpenAIIntegrationProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OpenAIIntegrationProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeOpenAIIntegrationProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(OpenAIIntegrationProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<OpenAIIntegrationProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
