// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Elastic.Models
{
    /// <summary> Marketplace Subscription. </summary>
    public partial class MarketplaceSaaSInfoMarketplaceSubscription
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MarketplaceSaaSInfoMarketplaceSubscription"/>. </summary>
        internal MarketplaceSaaSInfoMarketplaceSubscription()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MarketplaceSaaSInfoMarketplaceSubscription"/>. </summary>
        /// <param name="id"> Marketplace Subscription Id. This is a GUID-formatted string. </param>
        /// <param name="publisherId"> Publisher Id of the Marketplace offer. </param>
        /// <param name="offerId"> Offer Id of the Marketplace offer,. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MarketplaceSaaSInfoMarketplaceSubscription(string id, string publisherId, string offerId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            PublisherId = publisherId;
            OfferId = offerId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Marketplace Subscription Id. This is a GUID-formatted string. </summary>
        public string Id { get; }
        /// <summary> Publisher Id of the Marketplace offer. </summary>
        public string PublisherId { get; }
        /// <summary> Offer Id of the Marketplace offer,. </summary>
        public string OfferId { get; }
    }
}
