// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Elastic.Models
{
    /// <summary> Elastic traffic filter object. </summary>
    public partial class ElasticTrafficFilter
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ElasticTrafficFilter"/>. </summary>
        internal ElasticTrafficFilter()
        {
            Rules = new ChangeTrackingList<ElasticTrafficFilterRule>();
        }

        /// <summary> Initializes a new instance of <see cref="ElasticTrafficFilter"/>. </summary>
        /// <param name="id"> Id of the elastic filter. </param>
        /// <param name="name"> Name of the elastic filter. </param>
        /// <param name="description"> Description of the elastic filter. </param>
        /// <param name="region"> Region of the elastic filter. </param>
        /// <param name="elasticTrafficFilterType"> Type of the elastic filter. </param>
        /// <param name="includeByDefault"> IncludeByDefault for the elastic filter. </param>
        /// <param name="rules"> Rules in the elastic filter. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ElasticTrafficFilter(string id, string name, string description, string region, ElasticModelType? elasticTrafficFilterType, bool? includeByDefault, IReadOnlyList<ElasticTrafficFilterRule> rules, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            Description = description;
            Region = region;
            ElasticTrafficFilterType = elasticTrafficFilterType;
            IncludeByDefault = includeByDefault;
            Rules = rules;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Id of the elastic filter. </summary>
        public string Id { get; }
        /// <summary> Name of the elastic filter. </summary>
        public string Name { get; }
        /// <summary> Description of the elastic filter. </summary>
        public string Description { get; }
        /// <summary> Region of the elastic filter. </summary>
        public string Region { get; }
        /// <summary> Type of the elastic filter. </summary>
        public ElasticModelType? ElasticTrafficFilterType { get; }
        /// <summary> IncludeByDefault for the elastic filter. </summary>
        public bool? IncludeByDefault { get; }
        /// <summary> Rules in the elastic filter. </summary>
        public IReadOnlyList<ElasticTrafficFilterRule> Rules { get; }
    }
}
