// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Elastic.Models
{
    /// <summary> Elastic Resource Properties. </summary>
    public partial class ElasticProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ElasticProperties"/>. </summary>
        public ElasticProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ElasticProperties"/>. </summary>
        /// <param name="elasticCloudUser"> Details of the user's elastic account. </param>
        /// <param name="elasticCloudDeployment"> Details of the elastic cloud deployment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ElasticProperties(ElasticCloudUser elasticCloudUser, ElasticCloudDeployment elasticCloudDeployment, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ElasticCloudUser = elasticCloudUser;
            ElasticCloudDeployment = elasticCloudDeployment;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Details of the user's elastic account. </summary>
        public ElasticCloudUser ElasticCloudUser { get; set; }
        /// <summary> Details of the elastic cloud deployment. </summary>
        public ElasticCloudDeployment ElasticCloudDeployment { get; set; }
    }
}
