// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Elastic.Models
{
    public partial class ElasticOrganizationToAzureSubscriptionMappingResponseProperties : IUtf8JsonSerializable, IJsonModel<ElasticOrganizationToAzureSubscriptionMappingResponseProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ElasticOrganizationToAzureSubscriptionMappingResponseProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ElasticOrganizationToAzureSubscriptionMappingResponseProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ElasticOrganizationToAzureSubscriptionMappingResponseProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ElasticOrganizationToAzureSubscriptionMappingResponseProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(BilledAzureSubscriptionId))
            {
                writer.WritePropertyName("billedAzureSubscriptionId"u8);
                writer.WriteStringValue(BilledAzureSubscriptionId);
            }
            if (options.Format != "W" && Optional.IsDefined(MarketplaceSaasInfo))
            {
                writer.WritePropertyName("marketplaceSaasInfo"u8);
                writer.WriteObjectValue(MarketplaceSaasInfo, options);
            }
            if (Optional.IsDefined(ElasticOrganizationId))
            {
                writer.WritePropertyName("elasticOrganizationId"u8);
                writer.WriteStringValue(ElasticOrganizationId);
            }
            if (Optional.IsDefined(ElasticOrganizationName))
            {
                writer.WritePropertyName("elasticOrganizationName"u8);
                writer.WriteStringValue(ElasticOrganizationName);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ElasticOrganizationToAzureSubscriptionMappingResponseProperties IJsonModel<ElasticOrganizationToAzureSubscriptionMappingResponseProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ElasticOrganizationToAzureSubscriptionMappingResponseProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ElasticOrganizationToAzureSubscriptionMappingResponseProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeElasticOrganizationToAzureSubscriptionMappingResponseProperties(document.RootElement, options);
        }

        internal static ElasticOrganizationToAzureSubscriptionMappingResponseProperties DeserializeElasticOrganizationToAzureSubscriptionMappingResponseProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string billedAzureSubscriptionId = default;
            MarketplaceSaaSInfo marketplaceSaasInfo = default;
            string elasticOrganizationId = default;
            string elasticOrganizationName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("billedAzureSubscriptionId"u8))
                {
                    billedAzureSubscriptionId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("marketplaceSaasInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    marketplaceSaasInfo = MarketplaceSaaSInfo.DeserializeMarketplaceSaaSInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("elasticOrganizationId"u8))
                {
                    elasticOrganizationId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("elasticOrganizationName"u8))
                {
                    elasticOrganizationName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ElasticOrganizationToAzureSubscriptionMappingResponseProperties(billedAzureSubscriptionId, marketplaceSaasInfo, elasticOrganizationId, elasticOrganizationName, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ElasticOrganizationToAzureSubscriptionMappingResponseProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ElasticOrganizationToAzureSubscriptionMappingResponseProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ElasticOrganizationToAzureSubscriptionMappingResponseProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ElasticOrganizationToAzureSubscriptionMappingResponseProperties IPersistableModel<ElasticOrganizationToAzureSubscriptionMappingResponseProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ElasticOrganizationToAzureSubscriptionMappingResponseProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeElasticOrganizationToAzureSubscriptionMappingResponseProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ElasticOrganizationToAzureSubscriptionMappingResponseProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ElasticOrganizationToAzureSubscriptionMappingResponseProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
