// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Elastic.Models
{
    /// <summary> The operation for the patch on the resource. </summary>
    public readonly partial struct ElasticModelOperation : IEquatable<ElasticModelOperation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ElasticModelOperation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ElasticModelOperation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AddBeginValue = "AddBegin";
        private const string AddCompleteValue = "AddComplete";
        private const string DeleteBeginValue = "DeleteBegin";
        private const string DeleteCompleteValue = "DeleteComplete";
        private const string ActiveValue = "Active";

        /// <summary> AddBegin. </summary>
        public static ElasticModelOperation AddBegin { get; } = new ElasticModelOperation(AddBeginValue);
        /// <summary> AddComplete. </summary>
        public static ElasticModelOperation AddComplete { get; } = new ElasticModelOperation(AddCompleteValue);
        /// <summary> DeleteBegin. </summary>
        public static ElasticModelOperation DeleteBegin { get; } = new ElasticModelOperation(DeleteBeginValue);
        /// <summary> DeleteComplete. </summary>
        public static ElasticModelOperation DeleteComplete { get; } = new ElasticModelOperation(DeleteCompleteValue);
        /// <summary> Active. </summary>
        public static ElasticModelOperation Active { get; } = new ElasticModelOperation(ActiveValue);
        /// <summary> Determines if two <see cref="ElasticModelOperation"/> values are the same. </summary>
        public static bool operator ==(ElasticModelOperation left, ElasticModelOperation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ElasticModelOperation"/> values are not the same. </summary>
        public static bool operator !=(ElasticModelOperation left, ElasticModelOperation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ElasticModelOperation"/>. </summary>
        public static implicit operator ElasticModelOperation(string value) => new ElasticModelOperation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ElasticModelOperation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ElasticModelOperation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
