// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Elastic.Models
{
    /// <summary> Details of the user's elastic deployment associated with the monitor resource. </summary>
    public partial class ElasticCloudDeployment
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ElasticCloudDeployment"/>. </summary>
        public ElasticCloudDeployment()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ElasticCloudDeployment"/>. </summary>
        /// <param name="name"> Elastic deployment name. </param>
        /// <param name="deploymentId"> Elastic deployment Id. </param>
        /// <param name="azureSubscriptionId"> Associated Azure subscription Id for the elastic deployment. </param>
        /// <param name="elasticsearchRegion"> Region where Deployment at Elastic side took place. </param>
        /// <param name="elasticsearchServiceUri"> Elasticsearch ingestion endpoint of the Elastic deployment. </param>
        /// <param name="kibanaServiceUri"> Kibana endpoint of the Elastic deployment. </param>
        /// <param name="kibanaSsoUri"> Kibana dashboard sso URL of the Elastic deployment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ElasticCloudDeployment(string name, string deploymentId, string azureSubscriptionId, string elasticsearchRegion, Uri elasticsearchServiceUri, Uri kibanaServiceUri, Uri kibanaSsoUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            DeploymentId = deploymentId;
            AzureSubscriptionId = azureSubscriptionId;
            ElasticsearchRegion = elasticsearchRegion;
            ElasticsearchServiceUri = elasticsearchServiceUri;
            KibanaServiceUri = kibanaServiceUri;
            KibanaSsoUri = kibanaSsoUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Elastic deployment name. </summary>
        public string Name { get; }
        /// <summary> Elastic deployment Id. </summary>
        public string DeploymentId { get; }
        /// <summary> Associated Azure subscription Id for the elastic deployment. </summary>
        public string AzureSubscriptionId { get; }
        /// <summary> Region where Deployment at Elastic side took place. </summary>
        public string ElasticsearchRegion { get; }
        /// <summary> Elasticsearch ingestion endpoint of the Elastic deployment. </summary>
        public Uri ElasticsearchServiceUri { get; }
        /// <summary> Kibana endpoint of the Elastic deployment. </summary>
        public Uri KibanaServiceUri { get; }
        /// <summary> Kibana dashboard sso URL of the Elastic deployment. </summary>
        public Uri KibanaSsoUri { get; }
    }
}
