// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Elastic.Models
{
    public partial class ElasticCloudDeployment : IUtf8JsonSerializable, IJsonModel<ElasticCloudDeployment>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ElasticCloudDeployment>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ElasticCloudDeployment>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ElasticCloudDeployment>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ElasticCloudDeployment)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (options.Format != "W" && Optional.IsDefined(DeploymentId))
            {
                writer.WritePropertyName("deploymentId"u8);
                writer.WriteStringValue(DeploymentId);
            }
            if (options.Format != "W" && Optional.IsDefined(AzureSubscriptionId))
            {
                writer.WritePropertyName("azureSubscriptionId"u8);
                writer.WriteStringValue(AzureSubscriptionId);
            }
            if (options.Format != "W" && Optional.IsDefined(ElasticsearchRegion))
            {
                writer.WritePropertyName("elasticsearchRegion"u8);
                writer.WriteStringValue(ElasticsearchRegion);
            }
            if (options.Format != "W" && Optional.IsDefined(ElasticsearchServiceUri))
            {
                writer.WritePropertyName("elasticsearchServiceUrl"u8);
                writer.WriteStringValue(ElasticsearchServiceUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(KibanaServiceUri))
            {
                writer.WritePropertyName("kibanaServiceUrl"u8);
                writer.WriteStringValue(KibanaServiceUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(KibanaSsoUri))
            {
                writer.WritePropertyName("kibanaSsoUrl"u8);
                writer.WriteStringValue(KibanaSsoUri.AbsoluteUri);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ElasticCloudDeployment IJsonModel<ElasticCloudDeployment>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ElasticCloudDeployment>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ElasticCloudDeployment)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeElasticCloudDeployment(document.RootElement, options);
        }

        internal static ElasticCloudDeployment DeserializeElasticCloudDeployment(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string deploymentId = default;
            string azureSubscriptionId = default;
            string elasticsearchRegion = default;
            Uri elasticsearchServiceUrl = default;
            Uri kibanaServiceUrl = default;
            Uri kibanaSsoUrl = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("deploymentId"u8))
                {
                    deploymentId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("azureSubscriptionId"u8))
                {
                    azureSubscriptionId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("elasticsearchRegion"u8))
                {
                    elasticsearchRegion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("elasticsearchServiceUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    elasticsearchServiceUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("kibanaServiceUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    kibanaServiceUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("kibanaSsoUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    kibanaSsoUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ElasticCloudDeployment(
                name,
                deploymentId,
                azureSubscriptionId,
                elasticsearchRegion,
                elasticsearchServiceUrl,
                kibanaServiceUrl,
                kibanaSsoUrl,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ElasticCloudDeployment>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ElasticCloudDeployment>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ElasticCloudDeployment)} does not support writing '{options.Format}' format.");
            }
        }

        ElasticCloudDeployment IPersistableModel<ElasticCloudDeployment>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ElasticCloudDeployment>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeElasticCloudDeployment(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ElasticCloudDeployment)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ElasticCloudDeployment>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
