// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Elastic.Models
{
    /// <summary> The properties of deployment in Elastic cloud corresponding to the Elastic monitor resource. </summary>
    public partial class DeploymentInfoResponse
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeploymentInfoResponse"/>. </summary>
        internal DeploymentInfoResponse()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DeploymentInfoResponse"/>. </summary>
        /// <param name="status"> The Elastic deployment status. </param>
        /// <param name="version"> Version of the elasticsearch in Elastic cloud deployment. </param>
        /// <param name="memoryCapacity"> RAM capacity of the elasticsearch in Elastic cloud deployment. </param>
        /// <param name="diskCapacity"> Disk capacity of the elasticsearch in Elastic cloud deployment. </param>
        /// <param name="elasticsearchEndPoint"> Elasticsearch endpoint in Elastic cloud deployment. This is either the aliased_endpoint if available, or the service_url otherwise. </param>
        /// <param name="deploymentUri"> Deployment URL of the elasticsearch in Elastic cloud deployment. </param>
        /// <param name="marketplaceSaasInfo"> Marketplace SaaS Info of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeploymentInfoResponse(ElasticDeploymentStatus? status, string version, string memoryCapacity, string diskCapacity, string elasticsearchEndPoint, Uri deploymentUri, MarketplaceSaaSInfo marketplaceSaasInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            Version = version;
            MemoryCapacity = memoryCapacity;
            DiskCapacity = diskCapacity;
            ElasticsearchEndPoint = elasticsearchEndPoint;
            DeploymentUri = deploymentUri;
            MarketplaceSaasInfo = marketplaceSaasInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Elastic deployment status. </summary>
        public ElasticDeploymentStatus? Status { get; }
        /// <summary> Version of the elasticsearch in Elastic cloud deployment. </summary>
        public string Version { get; }
        /// <summary> RAM capacity of the elasticsearch in Elastic cloud deployment. </summary>
        public string MemoryCapacity { get; }
        /// <summary> Disk capacity of the elasticsearch in Elastic cloud deployment. </summary>
        public string DiskCapacity { get; }
        /// <summary> Elasticsearch endpoint in Elastic cloud deployment. This is either the aliased_endpoint if available, or the service_url otherwise. </summary>
        public string ElasticsearchEndPoint { get; }
        /// <summary> Deployment URL of the elasticsearch in Elastic cloud deployment. </summary>
        public Uri DeploymentUri { get; }
        /// <summary> Marketplace SaaS Info of the resource. </summary>
        public MarketplaceSaaSInfo MarketplaceSaasInfo { get; }
    }
}
