// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Elastic.Models
{
    /// <summary> Connected Partner Resource Properties. </summary>
    public partial class ConnectedPartnerResourceProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectedPartnerResourceProperties"/>. </summary>
        internal ConnectedPartnerResourceProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConnectedPartnerResourceProperties"/>. </summary>
        /// <param name="partnerDeploymentName"> Elastic deployment name. </param>
        /// <param name="partnerDeploymentUri"> Deployment URL of the elasticsearch in Elastic cloud deployment. </param>
        /// <param name="azureResourceId"> The azure resource Id of the deployment. </param>
        /// <param name="location"> The location of the deployment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectedPartnerResourceProperties(string partnerDeploymentName, Uri partnerDeploymentUri, string azureResourceId, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PartnerDeploymentName = partnerDeploymentName;
            PartnerDeploymentUri = partnerDeploymentUri;
            AzureResourceId = azureResourceId;
            Location = location;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Elastic deployment name. </summary>
        public string PartnerDeploymentName { get; }
        /// <summary> Deployment URL of the elasticsearch in Elastic cloud deployment. </summary>
        public Uri PartnerDeploymentUri { get; }
        /// <summary> The azure resource Id of the deployment. </summary>
        public string AzureResourceId { get; }
        /// <summary> The location of the deployment. </summary>
        public AzureLocation? Location { get; }
    }
}
