// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Elastic
{
    internal class MonitoredSubscriptionPropertyOperationSource : IOperationSource<MonitoredSubscriptionPropertyResource>
    {
        private readonly ArmClient _client;

        internal MonitoredSubscriptionPropertyOperationSource(ArmClient client)
        {
            _client = client;
        }

        MonitoredSubscriptionPropertyResource IOperationSource<MonitoredSubscriptionPropertyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MonitoredSubscriptionPropertyData.DeserializeMonitoredSubscriptionPropertyData(document.RootElement);
            return new MonitoredSubscriptionPropertyResource(_client, data);
        }

        async ValueTask<MonitoredSubscriptionPropertyResource> IOperationSource<MonitoredSubscriptionPropertyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MonitoredSubscriptionPropertyData.DeserializeMonitoredSubscriptionPropertyData(document.RootElement);
            return new MonitoredSubscriptionPropertyResource(_client, data);
        }
    }
}
