// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Elastic.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableElasticArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableElasticArmClient"/> class for mocking. </summary>
        protected MockableElasticArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableElasticArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableElasticArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableElasticArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing an <see cref="ElasticMonitorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ElasticMonitorResource.CreateResourceIdentifier" /> to create an <see cref="ElasticMonitorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ElasticMonitorResource"/> object. </returns>
        public virtual ElasticMonitorResource GetElasticMonitorResource(ResourceIdentifier id)
        {
            ElasticMonitorResource.ValidateResourceId(id);
            return new ElasticMonitorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MonitoredSubscriptionPropertyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MonitoredSubscriptionPropertyResource.CreateResourceIdentifier" /> to create a <see cref="MonitoredSubscriptionPropertyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MonitoredSubscriptionPropertyResource"/> object. </returns>
        public virtual MonitoredSubscriptionPropertyResource GetMonitoredSubscriptionPropertyResource(ResourceIdentifier id)
        {
            MonitoredSubscriptionPropertyResource.ValidateResourceId(id);
            return new MonitoredSubscriptionPropertyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="OpenAIIntegrationRPModelResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="OpenAIIntegrationRPModelResource.CreateResourceIdentifier" /> to create an <see cref="OpenAIIntegrationRPModelResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="OpenAIIntegrationRPModelResource"/> object. </returns>
        public virtual OpenAIIntegrationRPModelResource GetOpenAIIntegrationRPModelResource(ResourceIdentifier id)
        {
            OpenAIIntegrationRPModelResource.ValidateResourceId(id);
            return new OpenAIIntegrationRPModelResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="MonitoringTagRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="MonitoringTagRuleResource.CreateResourceIdentifier" /> to create a <see cref="MonitoringTagRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="MonitoringTagRuleResource"/> object. </returns>
        public virtual MonitoringTagRuleResource GetMonitoringTagRuleResource(ResourceIdentifier id)
        {
            MonitoringTagRuleResource.ValidateResourceId(id);
            return new MonitoringTagRuleResource(Client, id);
        }
    }
}
