// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Elastic.Models;

namespace Azure.ResourceManager.Elastic.Samples
{
    public partial class Sample_OpenAIIntegrationRPModelResource
    {
        // OpenAI_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_OpenAIGet()
        {
            // Generated from example definition: specification/elastic/resource-manager/Microsoft.Elastic/preview/2024-06-15-preview/examples/OpenAI_Get.json
            // this example is just showing the usage of "OpenAI_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this OpenAIIntegrationRPModelResource created on azure
            // for more information of creating OpenAIIntegrationRPModelResource, please refer to the document of OpenAIIntegrationRPModelResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string monitorName = "myMonitor";
            string integrationName = "default";
            ResourceIdentifier openAIIntegrationRPModelResourceId = OpenAIIntegrationRPModelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, monitorName, integrationName);
            OpenAIIntegrationRPModelResource openAIIntegrationRPModel = client.GetOpenAIIntegrationRPModelResource(openAIIntegrationRPModelResourceId);

            // invoke the operation
            OpenAIIntegrationRPModelResource result = await openAIIntegrationRPModel.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            OpenAIIntegrationRPModelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // OpenAI_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_OpenAICreateOrUpdate()
        {
            // Generated from example definition: specification/elastic/resource-manager/Microsoft.Elastic/preview/2024-06-15-preview/examples/OpenAI_CreateOrUpdate.json
            // this example is just showing the usage of "OpenAI_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this OpenAIIntegrationRPModelResource created on azure
            // for more information of creating OpenAIIntegrationRPModelResource, please refer to the document of OpenAIIntegrationRPModelResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string monitorName = "myMonitor";
            string integrationName = "default";
            ResourceIdentifier openAIIntegrationRPModelResourceId = OpenAIIntegrationRPModelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, monitorName, integrationName);
            OpenAIIntegrationRPModelResource openAIIntegrationRPModel = client.GetOpenAIIntegrationRPModelResource(openAIIntegrationRPModelResourceId);

            // invoke the operation
            OpenAIIntegrationRPModelData data = new OpenAIIntegrationRPModelData();
            ArmOperation<OpenAIIntegrationRPModelResource> lro = await openAIIntegrationRPModel.UpdateAsync(WaitUntil.Completed, data);
            OpenAIIntegrationRPModelResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            OpenAIIntegrationRPModelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // OpenAI_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_OpenAIDelete()
        {
            // Generated from example definition: specification/elastic/resource-manager/Microsoft.Elastic/preview/2024-06-15-preview/examples/OpenAI_Delete.json
            // this example is just showing the usage of "OpenAI_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this OpenAIIntegrationRPModelResource created on azure
            // for more information of creating OpenAIIntegrationRPModelResource, please refer to the document of OpenAIIntegrationRPModelResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string monitorName = "myMonitor";
            string integrationName = "default";
            ResourceIdentifier openAIIntegrationRPModelResourceId = OpenAIIntegrationRPModelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, monitorName, integrationName);
            OpenAIIntegrationRPModelResource openAIIntegrationRPModel = client.GetOpenAIIntegrationRPModelResource(openAIIntegrationRPModelResourceId);

            // invoke the operation
            await openAIIntegrationRPModel.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // OpenAI_GetStatus
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetStatus_OpenAIGetStatus()
        {
            // Generated from example definition: specification/elastic/resource-manager/Microsoft.Elastic/preview/2024-06-15-preview/examples/OpenAI_GetStatus.json
            // this example is just showing the usage of "OpenAI_GetStatus" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this OpenAIIntegrationRPModelResource created on azure
            // for more information of creating OpenAIIntegrationRPModelResource, please refer to the document of OpenAIIntegrationRPModelResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string monitorName = "myMonitor";
            string integrationName = "default";
            ResourceIdentifier openAIIntegrationRPModelResourceId = OpenAIIntegrationRPModelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, monitorName, integrationName);
            OpenAIIntegrationRPModelResource openAIIntegrationRPModel = client.GetOpenAIIntegrationRPModelResource(openAIIntegrationRPModelResourceId);

            // invoke the operation
            OpenAIIntegrationStatusResponse result = await openAIIntegrationRPModel.GetStatusAsync();

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
