// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Elastic.Samples
{
    public partial class Sample_MonitoredSubscriptionPropertyResource
    {
        // Monitors_GetMonitoredSubscriptions
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_MonitorsGetMonitoredSubscriptions()
        {
            // Generated from example definition: specification/elastic/resource-manager/Microsoft.Elastic/preview/2024-06-15-preview/examples/MonitoredSubscriptions_Get.json
            // this example is just showing the usage of "MonitoredSubscriptions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MonitoredSubscriptionPropertyResource created on azure
            // for more information of creating MonitoredSubscriptionPropertyResource, please refer to the document of MonitoredSubscriptionPropertyResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string monitorName = "myMonitor";
            string configurationName = "default";
            ResourceIdentifier monitoredSubscriptionPropertyResourceId = MonitoredSubscriptionPropertyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, monitorName, configurationName);
            MonitoredSubscriptionPropertyResource monitoredSubscriptionProperty = client.GetMonitoredSubscriptionPropertyResource(monitoredSubscriptionPropertyResourceId);

            // invoke the operation
            MonitoredSubscriptionPropertyResource result = await monitoredSubscriptionProperty.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MonitoredSubscriptionPropertyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Monitors_UpdateMonitoredSubscriptions
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_MonitorsUpdateMonitoredSubscriptions()
        {
            // Generated from example definition: specification/elastic/resource-manager/Microsoft.Elastic/preview/2024-06-15-preview/examples/MonitoredSubscriptions_Update.json
            // this example is just showing the usage of "MonitoredSubscriptions_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MonitoredSubscriptionPropertyResource created on azure
            // for more information of creating MonitoredSubscriptionPropertyResource, please refer to the document of MonitoredSubscriptionPropertyResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string monitorName = "myMonitor";
            string configurationName = "default";
            ResourceIdentifier monitoredSubscriptionPropertyResourceId = MonitoredSubscriptionPropertyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, monitorName, configurationName);
            MonitoredSubscriptionPropertyResource monitoredSubscriptionProperty = client.GetMonitoredSubscriptionPropertyResource(monitoredSubscriptionPropertyResourceId);

            // invoke the operation
            MonitoredSubscriptionPropertyData data = new MonitoredSubscriptionPropertyData();
            ArmOperation<MonitoredSubscriptionPropertyResource> lro = await monitoredSubscriptionProperty.UpdateAsync(WaitUntil.Completed, data);
            MonitoredSubscriptionPropertyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MonitoredSubscriptionPropertyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Monitors_DeleteMonitoredSubscriptions
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_MonitorsDeleteMonitoredSubscriptions()
        {
            // Generated from example definition: specification/elastic/resource-manager/Microsoft.Elastic/preview/2024-06-15-preview/examples/MonitoredSubscriptions_Delete.json
            // this example is just showing the usage of "MonitoredSubscriptions_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MonitoredSubscriptionPropertyResource created on azure
            // for more information of creating MonitoredSubscriptionPropertyResource, please refer to the document of MonitoredSubscriptionPropertyResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string monitorName = "myMonitor";
            string configurationName = "default";
            ResourceIdentifier monitoredSubscriptionPropertyResourceId = MonitoredSubscriptionPropertyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, monitorName, configurationName);
            MonitoredSubscriptionPropertyResource monitoredSubscriptionProperty = client.GetMonitoredSubscriptionPropertyResource(monitoredSubscriptionPropertyResourceId);

            // invoke the operation
            await monitoredSubscriptionProperty.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
