// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EdgeZones.Models
{
    /// <summary> The Azure Extended Zone registration status for a subscription. </summary>
    public readonly partial struct EdgeZonesRegistrationState : IEquatable<EdgeZonesRegistrationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EdgeZonesRegistrationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EdgeZonesRegistrationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotRegisteredValue = "NotRegistered";
        private const string PendingRegisterValue = "PendingRegister";
        private const string RegisteredValue = "Registered";
        private const string PendingUnregisterValue = "PendingUnregister";

        /// <summary> Subscription not registered for the Azure Extended Zone. </summary>
        public static EdgeZonesRegistrationState NotRegistered { get; } = new EdgeZonesRegistrationState(NotRegisteredValue);
        /// <summary> Subscription pending registration for the Azure Extended Zone. </summary>
        public static EdgeZonesRegistrationState PendingRegister { get; } = new EdgeZonesRegistrationState(PendingRegisterValue);
        /// <summary> Subscription is registered for the Azure Extended Zone. </summary>
        public static EdgeZonesRegistrationState Registered { get; } = new EdgeZonesRegistrationState(RegisteredValue);
        /// <summary> Subscription is pending unregistering for the Azure Extended Zone. </summary>
        public static EdgeZonesRegistrationState PendingUnregister { get; } = new EdgeZonesRegistrationState(PendingUnregisterValue);
        /// <summary> Determines if two <see cref="EdgeZonesRegistrationState"/> values are the same. </summary>
        public static bool operator ==(EdgeZonesRegistrationState left, EdgeZonesRegistrationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EdgeZonesRegistrationState"/> values are not the same. </summary>
        public static bool operator !=(EdgeZonesRegistrationState left, EdgeZonesRegistrationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EdgeZonesRegistrationState"/>. </summary>
        public static implicit operator EdgeZonesRegistrationState(string value) => new EdgeZonesRegistrationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EdgeZonesRegistrationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EdgeZonesRegistrationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
