// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EdgeZones.Models
{
    /// <summary> The status of the current operation. </summary>
    public readonly partial struct EdgeZonesProvisioningState : IEquatable<EdgeZonesProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EdgeZonesProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EdgeZonesProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ProvisioningValue = "Provisioning";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string AcceptedValue = "Accepted";

        /// <summary> Resource has been created. </summary>
        public static EdgeZonesProvisioningState Succeeded { get; } = new EdgeZonesProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static EdgeZonesProvisioningState Failed { get; } = new EdgeZonesProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static EdgeZonesProvisioningState Canceled { get; } = new EdgeZonesProvisioningState(CanceledValue);
        /// <summary> Provisioning State. </summary>
        public static EdgeZonesProvisioningState Provisioning { get; } = new EdgeZonesProvisioningState(ProvisioningValue);
        /// <summary> Updating State. </summary>
        public static EdgeZonesProvisioningState Updating { get; } = new EdgeZonesProvisioningState(UpdatingValue);
        /// <summary> Deleting State. </summary>
        public static EdgeZonesProvisioningState Deleting { get; } = new EdgeZonesProvisioningState(DeletingValue);
        /// <summary> Accepted State. </summary>
        public static EdgeZonesProvisioningState Accepted { get; } = new EdgeZonesProvisioningState(AcceptedValue);
        /// <summary> Determines if two <see cref="EdgeZonesProvisioningState"/> values are the same. </summary>
        public static bool operator ==(EdgeZonesProvisioningState left, EdgeZonesProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EdgeZonesProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(EdgeZonesProvisioningState left, EdgeZonesProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EdgeZonesProvisioningState"/>. </summary>
        public static implicit operator EdgeZonesProvisioningState(string value) => new EdgeZonesProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EdgeZonesProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EdgeZonesProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
