// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.EdgeZones.Mocking
{
    /// <summary> A class to add extension methods to SubscriptionResource. </summary>
    public partial class MockableEdgeZonesSubscriptionResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableEdgeZonesSubscriptionResource"/> class for mocking. </summary>
        protected MockableEdgeZonesSubscriptionResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableEdgeZonesSubscriptionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableEdgeZonesSubscriptionResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of ExtendedZoneResources in the SubscriptionResource. </summary>
        /// <returns> An object representing collection of ExtendedZoneResources and their operations over a ExtendedZoneResource. </returns>
        public virtual ExtendedZoneCollection GetExtendedZones()
        {
            return GetCachedClient(client => new ExtendedZoneCollection(client, Id));
        }

        /// <summary>
        /// Gets an Azure Extended Zone for a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.EdgeZones/extendedZones/{extendedZoneName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="extendedZoneName"> The name of the ExtendedZone. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="extendedZoneName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="extendedZoneName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<ExtendedZoneResource>> GetExtendedZoneAsync(string extendedZoneName, CancellationToken cancellationToken = default)
        {
            return await GetExtendedZones().GetAsync(extendedZoneName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets an Azure Extended Zone for a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.EdgeZones/extendedZones/{extendedZoneName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="extendedZoneName"> The name of the ExtendedZone. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="extendedZoneName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="extendedZoneName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<ExtendedZoneResource> GetExtendedZone(string extendedZoneName, CancellationToken cancellationToken = default)
        {
            return GetExtendedZones().Get(extendedZoneName, cancellationToken);
        }
    }
}
