// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.EdgeZones.Mocking;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.EdgeZones
{
    /// <summary> A class to add extension methods to Azure.ResourceManager.EdgeZones. </summary>
    public static partial class EdgeZonesExtensions
    {
        private static MockableEdgeZonesArmClient GetMockableEdgeZonesArmClient(ArmClient client)
        {
            return client.GetCachedClient(client0 => new MockableEdgeZonesArmClient(client0));
        }

        private static MockableEdgeZonesSubscriptionResource GetMockableEdgeZonesSubscriptionResource(ArmResource resource)
        {
            return resource.GetCachedClient(client => new MockableEdgeZonesSubscriptionResource(client, resource.Id));
        }

        /// <summary>
        /// Gets an object representing an <see cref="ExtendedZoneResource" /> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ExtendedZoneResource.CreateResourceIdentifier" /> to create an <see cref="ExtendedZoneResource" /> <see cref="ResourceIdentifier" /> from its components.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableEdgeZonesArmClient.GetExtendedZoneResource(ResourceIdentifier)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="client"> The <see cref="ArmClient" /> instance the method will execute against. </param>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="client"/> is null. </exception>
        /// <returns> Returns a <see cref="ExtendedZoneResource"/> object. </returns>
        public static ExtendedZoneResource GetExtendedZoneResource(this ArmClient client, ResourceIdentifier id)
        {
            Argument.AssertNotNull(client, nameof(client));

            return GetMockableEdgeZonesArmClient(client).GetExtendedZoneResource(id);
        }

        /// <summary>
        /// Gets a collection of ExtendedZoneResources in the SubscriptionResource.
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableEdgeZonesSubscriptionResource.GetExtendedZones()"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> is null. </exception>
        /// <returns> An object representing collection of ExtendedZoneResources and their operations over a ExtendedZoneResource. </returns>
        public static ExtendedZoneCollection GetExtendedZones(this SubscriptionResource subscriptionResource)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableEdgeZonesSubscriptionResource(subscriptionResource).GetExtendedZones();
        }

        /// <summary>
        /// Gets an Azure Extended Zone for a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.EdgeZones/extendedZones/{extendedZoneName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedZoneResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableEdgeZonesSubscriptionResource.GetExtendedZoneAsync(string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="extendedZoneName"> The name of the ExtendedZone. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> or <paramref name="extendedZoneName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="extendedZoneName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static async Task<Response<ExtendedZoneResource>> GetExtendedZoneAsync(this SubscriptionResource subscriptionResource, string extendedZoneName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return await GetMockableEdgeZonesSubscriptionResource(subscriptionResource).GetExtendedZoneAsync(extendedZoneName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets an Azure Extended Zone for a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.EdgeZones/extendedZones/{extendedZoneName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedZoneResource"/></description>
        /// </item>
        /// </list>
        /// <item>
        /// <term>Mocking</term>
        /// <description>To mock this method, please mock <see cref="MockableEdgeZonesSubscriptionResource.GetExtendedZone(string,CancellationToken)"/> instead.</description>
        /// </item>
        /// </summary>
        /// <param name="subscriptionResource"> The <see cref="SubscriptionResource" /> instance the method will execute against. </param>
        /// <param name="extendedZoneName"> The name of the ExtendedZone. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionResource"/> or <paramref name="extendedZoneName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="extendedZoneName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public static Response<ExtendedZoneResource> GetExtendedZone(this SubscriptionResource subscriptionResource, string extendedZoneName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(subscriptionResource, nameof(subscriptionResource));

            return GetMockableEdgeZonesSubscriptionResource(subscriptionResource).GetExtendedZone(extendedZoneName, cancellationToken);
        }
    }
}
