// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.EdgeZones
{
    /// <summary>
    /// A class representing a collection of <see cref="ExtendedZoneResource"/> and their operations.
    /// Each <see cref="ExtendedZoneResource"/> in the collection will belong to the same instance of <see cref="SubscriptionResource"/>.
    /// To get an <see cref="ExtendedZoneCollection"/> instance call the GetExtendedZones method from an instance of <see cref="SubscriptionResource"/>.
    /// </summary>
    public partial class ExtendedZoneCollection : ArmCollection, IEnumerable<ExtendedZoneResource>, IAsyncEnumerable<ExtendedZoneResource>
    {
        private readonly ClientDiagnostics _extendedZoneClientDiagnostics;
        private readonly ExtendedZonesRestOperations _extendedZoneRestClient;

        /// <summary> Initializes a new instance of the <see cref="ExtendedZoneCollection"/> class for mocking. </summary>
        protected ExtendedZoneCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ExtendedZoneCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ExtendedZoneCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _extendedZoneClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.EdgeZones", ExtendedZoneResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ExtendedZoneResource.ResourceType, out string extendedZoneApiVersion);
            _extendedZoneRestClient = new ExtendedZonesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, extendedZoneApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SubscriptionResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SubscriptionResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets an Azure Extended Zone for a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.EdgeZones/extendedZones/{extendedZoneName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="extendedZoneName"> The name of the ExtendedZone. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="extendedZoneName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="extendedZoneName"/> is null. </exception>
        public virtual async Task<Response<ExtendedZoneResource>> GetAsync(string extendedZoneName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(extendedZoneName, nameof(extendedZoneName));

            using var scope = _extendedZoneClientDiagnostics.CreateScope("ExtendedZoneCollection.Get");
            scope.Start();
            try
            {
                var response = await _extendedZoneRestClient.GetAsync(Id.SubscriptionId, extendedZoneName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ExtendedZoneResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an Azure Extended Zone for a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.EdgeZones/extendedZones/{extendedZoneName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="extendedZoneName"> The name of the ExtendedZone. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="extendedZoneName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="extendedZoneName"/> is null. </exception>
        public virtual Response<ExtendedZoneResource> Get(string extendedZoneName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(extendedZoneName, nameof(extendedZoneName));

            using var scope = _extendedZoneClientDiagnostics.CreateScope("ExtendedZoneCollection.Get");
            scope.Start();
            try
            {
                var response = _extendedZoneRestClient.Get(Id.SubscriptionId, extendedZoneName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ExtendedZoneResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the Azure Extended Zones available to a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.EdgeZones/extendedZones</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedZones_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ExtendedZoneResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ExtendedZoneResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _extendedZoneRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _extendedZoneRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ExtendedZoneResource(Client, ExtendedZoneData.DeserializeExtendedZoneData(e)), _extendedZoneClientDiagnostics, Pipeline, "ExtendedZoneCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the Azure Extended Zones available to a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.EdgeZones/extendedZones</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedZones_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ExtendedZoneResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ExtendedZoneResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _extendedZoneRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _extendedZoneRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ExtendedZoneResource(Client, ExtendedZoneData.DeserializeExtendedZoneData(e)), _extendedZoneClientDiagnostics, Pipeline, "ExtendedZoneCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.EdgeZones/extendedZones/{extendedZoneName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="extendedZoneName"> The name of the ExtendedZone. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="extendedZoneName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="extendedZoneName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string extendedZoneName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(extendedZoneName, nameof(extendedZoneName));

            using var scope = _extendedZoneClientDiagnostics.CreateScope("ExtendedZoneCollection.Exists");
            scope.Start();
            try
            {
                var response = await _extendedZoneRestClient.GetAsync(Id.SubscriptionId, extendedZoneName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.EdgeZones/extendedZones/{extendedZoneName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="extendedZoneName"> The name of the ExtendedZone. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="extendedZoneName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="extendedZoneName"/> is null. </exception>
        public virtual Response<bool> Exists(string extendedZoneName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(extendedZoneName, nameof(extendedZoneName));

            using var scope = _extendedZoneClientDiagnostics.CreateScope("ExtendedZoneCollection.Exists");
            scope.Start();
            try
            {
                var response = _extendedZoneRestClient.Get(Id.SubscriptionId, extendedZoneName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.EdgeZones/extendedZones/{extendedZoneName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="extendedZoneName"> The name of the ExtendedZone. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="extendedZoneName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="extendedZoneName"/> is null. </exception>
        public virtual async Task<NullableResponse<ExtendedZoneResource>> GetIfExistsAsync(string extendedZoneName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(extendedZoneName, nameof(extendedZoneName));

            using var scope = _extendedZoneClientDiagnostics.CreateScope("ExtendedZoneCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _extendedZoneRestClient.GetAsync(Id.SubscriptionId, extendedZoneName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ExtendedZoneResource>(response.GetRawResponse());
                return Response.FromValue(new ExtendedZoneResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.EdgeZones/extendedZones/{extendedZoneName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ExtendedZones_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ExtendedZoneResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="extendedZoneName"> The name of the ExtendedZone. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="extendedZoneName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="extendedZoneName"/> is null. </exception>
        public virtual NullableResponse<ExtendedZoneResource> GetIfExists(string extendedZoneName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(extendedZoneName, nameof(extendedZoneName));

            using var scope = _extendedZoneClientDiagnostics.CreateScope("ExtendedZoneCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _extendedZoneRestClient.Get(Id.SubscriptionId, extendedZoneName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ExtendedZoneResource>(response.GetRawResponse());
                return Response.FromValue(new ExtendedZoneResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ExtendedZoneResource> IEnumerable<ExtendedZoneResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ExtendedZoneResource> IAsyncEnumerable<ExtendedZoneResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
