// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.EdgeZones.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmEdgeZonesModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="EdgeZones.ExtendedZoneData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Status of the last operation performed by the subscription on the Edge Zone resource. </param>
        /// <param name="registrationState"> Indicates the Azure Extended Zone registration’s approval status. </param>
        /// <param name="displayName"> Display name of the Azure Extended Zone. </param>
        /// <param name="regionalDisplayName"> Regional display name of the Azure Extended Zone. </param>
        /// <param name="regionType"> Type of region for the Azure Extended Zone. </param>
        /// <param name="regionCategory"> Category of region for the Azure Extended Zone. </param>
        /// <param name="geography"> Geography of the Azure Extended Zone. </param>
        /// <param name="geographyGroup"> The Geography Group of the Azure Extended Zone. </param>
        /// <param name="longitude"> The Longitude of the Azure Extended Zone. </param>
        /// <param name="latitude"> The Latitude of the Azure Extended Zone. </param>
        /// <param name="homeLocation"> The Home Location of the Azure Extended Zone. </param>
        /// <returns> A new <see cref="EdgeZones.ExtendedZoneData"/> instance for mocking. </returns>
        public static ExtendedZoneData ExtendedZoneData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, EdgeZonesProvisioningState? provisioningState = null, EdgeZonesRegistrationState? registrationState = null, string displayName = null, string regionalDisplayName = null, string regionType = null, string regionCategory = null, string geography = null, string geographyGroup = null, string longitude = null, string latitude = null, string homeLocation = null)
        {
            return new ExtendedZoneData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                registrationState,
                displayName,
                regionalDisplayName,
                regionType,
                regionCategory,
                geography,
                geographyGroup,
                longitude,
                latitude,
                homeLocation,
                serializedAdditionalRawData: null);
        }
    }
}
