// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.EdgeZones.Samples
{
    public partial class Sample_ExtendedZoneResource
    {
        // GetExtendedZone
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetExtendedZone()
        {
            // Generated from example definition: specification/edgezones/resource-manager/Microsoft.EdgeZones/preview/2024-04-01-preview/examples/ExtendedZones_Get.json
            // this example is just showing the usage of "ExtendedZones_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExtendedZoneResource created on azure
            // for more information of creating ExtendedZoneResource, please refer to the document of ExtendedZoneResource
            string subscriptionId = "a1ffc958-d2c7-493e-9f1e-125a0477f536";
            string extendedZoneName = "losangeles";
            ResourceIdentifier extendedZoneResourceId = ExtendedZoneResource.CreateResourceIdentifier(subscriptionId, extendedZoneName);
            ExtendedZoneResource extendedZone = client.GetExtendedZoneResource(extendedZoneResourceId);

            // invoke the operation
            ExtendedZoneResource result = await extendedZone.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ExtendedZoneData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // RegisterExtendedZone
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Register_RegisterExtendedZone()
        {
            // Generated from example definition: specification/edgezones/resource-manager/Microsoft.EdgeZones/preview/2024-04-01-preview/examples/ExtendedZones_Register.json
            // this example is just showing the usage of "ExtendedZones_Register" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExtendedZoneResource created on azure
            // for more information of creating ExtendedZoneResource, please refer to the document of ExtendedZoneResource
            string subscriptionId = "a1ffc958-d2c7-493e-9f1e-125a0477f536";
            string extendedZoneName = "losangeles";
            ResourceIdentifier extendedZoneResourceId = ExtendedZoneResource.CreateResourceIdentifier(subscriptionId, extendedZoneName);
            ExtendedZoneResource extendedZone = client.GetExtendedZoneResource(extendedZoneResourceId);

            // invoke the operation
            ExtendedZoneResource result = await extendedZone.RegisterAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ExtendedZoneData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // UnregisterExtendedZone
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Unregister_UnregisterExtendedZone()
        {
            // Generated from example definition: specification/edgezones/resource-manager/Microsoft.EdgeZones/preview/2024-04-01-preview/examples/ExtendedZones_Unregister.json
            // this example is just showing the usage of "ExtendedZones_Unregister" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ExtendedZoneResource created on azure
            // for more information of creating ExtendedZoneResource, please refer to the document of ExtendedZoneResource
            string subscriptionId = "a1ffc958-d2c7-493e-9f1e-125a0477f536";
            string extendedZoneName = "losangeles";
            ResourceIdentifier extendedZoneResourceId = ExtendedZoneResource.CreateResourceIdentifier(subscriptionId, extendedZoneName);
            ExtendedZoneResource extendedZone = client.GetExtendedZoneResource(extendedZoneResourceId);

            // invoke the operation
            ExtendedZoneResource result = await extendedZone.UnregisterAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ExtendedZoneData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
