// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Indicates Shipment Logistics type that the customer preferred. </summary>
    public readonly partial struct TransportShipmentType : IEquatable<TransportShipmentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TransportShipmentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TransportShipmentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CustomerManagedValue = "CustomerManaged";
        private const string MicrosoftManagedValue = "MicrosoftManaged";

        /// <summary> Shipment Logistics is handled by the customer. </summary>
        public static TransportShipmentType CustomerManaged { get; } = new TransportShipmentType(CustomerManagedValue);
        /// <summary> Shipment Logistics is handled by Microsoft. </summary>
        public static TransportShipmentType MicrosoftManaged { get; } = new TransportShipmentType(MicrosoftManagedValue);
        /// <summary> Determines if two <see cref="TransportShipmentType"/> values are the same. </summary>
        public static bool operator ==(TransportShipmentType left, TransportShipmentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TransportShipmentType"/> values are not the same. </summary>
        public static bool operator !=(TransportShipmentType left, TransportShipmentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TransportShipmentType"/>. </summary>
        public static implicit operator TransportShipmentType(string value) => new TransportShipmentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TransportShipmentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TransportShipmentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
