// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Type of product filter. </summary>
    public readonly partial struct SupportedFilterType : IEquatable<SupportedFilterType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SupportedFilterType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SupportedFilterType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ShipToCountriesValue = "ShipToCountries";
        private const string DoubleEncryptionStatusValue = "DoubleEncryptionStatus";

        /// <summary> Ship to country. </summary>
        public static SupportedFilterType ShipToCountries { get; } = new SupportedFilterType(ShipToCountriesValue);
        /// <summary> Double encryption status. </summary>
        public static SupportedFilterType DoubleEncryptionStatus { get; } = new SupportedFilterType(DoubleEncryptionStatusValue);
        /// <summary> Determines if two <see cref="SupportedFilterType"/> values are the same. </summary>
        public static bool operator ==(SupportedFilterType left, SupportedFilterType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SupportedFilterType"/> values are not the same. </summary>
        public static bool operator !=(SupportedFilterType left, SupportedFilterType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SupportedFilterType"/>. </summary>
        public static implicit operator SupportedFilterType(string value) => new SupportedFilterType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SupportedFilterType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SupportedFilterType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
