// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Type of link. </summary>
    public readonly partial struct ProductLinkType : IEquatable<ProductLinkType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProductLinkType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProductLinkType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GenericValue = "Generic";
        private const string TermsAndConditionsValue = "TermsAndConditions";
        private const string SpecificationValue = "Specification";
        private const string DocumentationValue = "Documentation";
        private const string KnowMoreValue = "KnowMore";
        private const string SignUpValue = "SignUp";

        /// <summary> Generic link. </summary>
        public static ProductLinkType Generic { get; } = new ProductLinkType(GenericValue);
        /// <summary> Terms and conditions link. </summary>
        public static ProductLinkType TermsAndConditions { get; } = new ProductLinkType(TermsAndConditionsValue);
        /// <summary> Link to product specification. </summary>
        public static ProductLinkType Specification { get; } = new ProductLinkType(SpecificationValue);
        /// <summary> Link to product documentation. </summary>
        public static ProductLinkType Documentation { get; } = new ProductLinkType(DocumentationValue);
        /// <summary> Link to know more. </summary>
        public static ProductLinkType KnowMore { get; } = new ProductLinkType(KnowMoreValue);
        /// <summary> Link to sign up for products. </summary>
        public static ProductLinkType SignUp { get; } = new ProductLinkType(SignUpValue);
        /// <summary> Determines if two <see cref="ProductLinkType"/> values are the same. </summary>
        public static bool operator ==(ProductLinkType left, ProductLinkType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProductLinkType"/> values are not the same. </summary>
        public static bool operator !=(ProductLinkType left, ProductLinkType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProductLinkType"/>. </summary>
        public static implicit operator ProductLinkType(string value) => new ProductLinkType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProductLinkType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProductLinkType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
