// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Returns link related to the product. </summary>
    public partial class ProductLink
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ProductLink"/>. </summary>
        internal ProductLink()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ProductLink"/>. </summary>
        /// <param name="linkType"> Type of link. </param>
        /// <param name="linkUri"> Url of the link. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ProductLink(ProductLinkType? linkType, Uri linkUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LinkType = linkType;
            LinkUri = linkUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of link. </summary>
        public ProductLinkType? LinkType { get; }
        /// <summary> Url of the link. </summary>
        public Uri LinkUri { get; }
    }
}
