// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Unit for the dimensions of length, height and width. </summary>
    public readonly partial struct ProductLengthHeightWidthUnit : IEquatable<ProductLengthHeightWidthUnit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProductLengthHeightWidthUnit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProductLengthHeightWidthUnit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string INValue = "IN";
        private const string CMValue = "CM";

        /// <summary> Inch, applicable for West US. </summary>
        public static ProductLengthHeightWidthUnit IN { get; } = new ProductLengthHeightWidthUnit(INValue);
        /// <summary> Centimeter. </summary>
        public static ProductLengthHeightWidthUnit CM { get; } = new ProductLengthHeightWidthUnit(CMValue);
        /// <summary> Determines if two <see cref="ProductLengthHeightWidthUnit"/> values are the same. </summary>
        public static bool operator ==(ProductLengthHeightWidthUnit left, ProductLengthHeightWidthUnit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProductLengthHeightWidthUnit"/> values are not the same. </summary>
        public static bool operator !=(ProductLengthHeightWidthUnit left, ProductLengthHeightWidthUnit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProductLengthHeightWidthUnit"/>. </summary>
        public static implicit operator ProductLengthHeightWidthUnit(string value) => new ProductLengthHeightWidthUnit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProductLengthHeightWidthUnit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProductLengthHeightWidthUnit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
