// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Type of description. </summary>
    public readonly partial struct ProductDescriptionType : IEquatable<ProductDescriptionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProductDescriptionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProductDescriptionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BaseValue = "Base";

        /// <summary> Base description. </summary>
        public static ProductDescriptionType Base { get; } = new ProductDescriptionType(BaseValue);
        /// <summary> Determines if two <see cref="ProductDescriptionType"/> values are the same. </summary>
        public static bool operator ==(ProductDescriptionType left, ProductDescriptionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProductDescriptionType"/> values are not the same. </summary>
        public static bool operator !=(ProductDescriptionType left, ProductDescriptionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProductDescriptionType"/>. </summary>
        public static implicit operator ProductDescriptionType(string value) => new ProductDescriptionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProductDescriptionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProductDescriptionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
