// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Availability information of a product system. </summary>
    public partial class ProductAvailabilityInformation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ProductAvailabilityInformation"/>. </summary>
        internal ProductAvailabilityInformation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ProductAvailabilityInformation"/>. </summary>
        /// <param name="availabilityStage"> Current availability stage of the product. Availability stage. </param>
        /// <param name="disabledReason"> Reason why the product is disabled. </param>
        /// <param name="disabledReasonMessage"> Message for why the product is disabled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ProductAvailabilityInformation(ProductAvailabilityStage? availabilityStage, ProductDisabledReason? disabledReason, string disabledReasonMessage, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AvailabilityStage = availabilityStage;
            DisabledReason = disabledReason;
            DisabledReasonMessage = disabledReasonMessage;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Current availability stage of the product. Availability stage. </summary>
        public ProductAvailabilityStage? AvailabilityStage { get; }
        /// <summary> Reason why the product is disabled. </summary>
        public ProductDisabledReason? DisabledReason { get; }
        /// <summary> Message for why the product is disabled. </summary>
        public string DisabledReasonMessage { get; }
    }
}
