// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Order item type. </summary>
    public readonly partial struct OrderItemType : IEquatable<OrderItemType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OrderItemType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OrderItemType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PurchaseValue = "Purchase";
        private const string RentalValue = "Rental";

        /// <summary> Purchase OrderItem. </summary>
        public static OrderItemType Purchase { get; } = new OrderItemType(PurchaseValue);
        /// <summary> Rental OrderItem. </summary>
        public static OrderItemType Rental { get; } = new OrderItemType(RentalValue);
        /// <summary> Determines if two <see cref="OrderItemType"/> values are the same. </summary>
        public static bool operator ==(OrderItemType left, OrderItemType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OrderItemType"/> values are not the same. </summary>
        public static bool operator !=(OrderItemType left, OrderItemType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OrderItemType"/>. </summary>
        public static implicit operator OrderItemType(string value) => new OrderItemType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OrderItemType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OrderItemType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
