// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Describes whether the order item is cancellable or not. </summary>
    public readonly partial struct OrderItemCancellationStatus : IEquatable<OrderItemCancellationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OrderItemCancellationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OrderItemCancellationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CancellableValue = "Cancellable";
        private const string CancellableWithFeeValue = "CancellableWithFee";
        private const string NotCancellableValue = "NotCancellable";

        /// <summary> Order item can be cancelled without fee. </summary>
        public static OrderItemCancellationStatus Cancellable { get; } = new OrderItemCancellationStatus(CancellableValue);
        /// <summary> Order item can be cancelled with fee. </summary>
        public static OrderItemCancellationStatus CancellableWithFee { get; } = new OrderItemCancellationStatus(CancellableWithFeeValue);
        /// <summary> Order item not cancellable. </summary>
        public static OrderItemCancellationStatus NotCancellable { get; } = new OrderItemCancellationStatus(NotCancellableValue);
        /// <summary> Determines if two <see cref="OrderItemCancellationStatus"/> values are the same. </summary>
        public static bool operator ==(OrderItemCancellationStatus left, OrderItemCancellationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OrderItemCancellationStatus"/> values are not the same. </summary>
        public static bool operator !=(OrderItemCancellationStatus left, OrderItemCancellationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OrderItemCancellationStatus"/>. </summary>
        public static implicit operator OrderItemCancellationStatus(string value) => new OrderItemCancellationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OrderItemCancellationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OrderItemCancellationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
