// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Name of the stage. </summary>
    public readonly partial struct NotificationStageName : IEquatable<NotificationStageName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NotificationStageName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NotificationStageName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ShippedValue = "Shipped";
        private const string DeliveredValue = "Delivered";

        /// <summary> Notification at order item shipped from microsoft datacenter. </summary>
        public static NotificationStageName Shipped { get; } = new NotificationStageName(ShippedValue);
        /// <summary> Notification at order item delivered to customer. </summary>
        public static NotificationStageName Delivered { get; } = new NotificationStageName(DeliveredValue);
        /// <summary> Determines if two <see cref="NotificationStageName"/> values are the same. </summary>
        public static bool operator ==(NotificationStageName left, NotificationStageName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NotificationStageName"/> values are not the same. </summary>
        public static bool operator !=(NotificationStageName left, NotificationStageName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NotificationStageName"/>. </summary>
        public static implicit operator NotificationStageName(string value) => new NotificationStageName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NotificationStageName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NotificationStageName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
