// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Notification preference for a job stage. </summary>
    public partial class NotificationPreference
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NotificationPreference"/>. </summary>
        /// <param name="stageName"> Name of the stage. </param>
        /// <param name="isNotificationRequired"> Notification is required or not. </param>
        public NotificationPreference(NotificationStageName stageName, bool isNotificationRequired)
        {
            StageName = stageName;
            IsNotificationRequired = isNotificationRequired;
        }

        /// <summary> Initializes a new instance of <see cref="NotificationPreference"/>. </summary>
        /// <param name="stageName"> Name of the stage. </param>
        /// <param name="isNotificationRequired"> Notification is required or not. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NotificationPreference(NotificationStageName stageName, bool isNotificationRequired, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StageName = stageName;
            IsNotificationRequired = isNotificationRequired;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="NotificationPreference"/> for deserialization. </summary>
        internal NotificationPreference()
        {
        }

        /// <summary> Name of the stage. </summary>
        public NotificationStageName StageName { get; set; }
        /// <summary> Notification is required or not. </summary>
        public bool IsNotificationRequired { get; set; }
    }
}
