// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Holds details about product hierarchy information. </summary>
    public partial class HierarchyInformation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HierarchyInformation"/>. </summary>
        public HierarchyInformation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HierarchyInformation"/>. </summary>
        /// <param name="productFamilyName"> Represents product family name that uniquely identifies product family. </param>
        /// <param name="productLineName"> Represents product line name that uniquely identifies product line. </param>
        /// <param name="productName"> Represents product name that uniquely identifies product. </param>
        /// <param name="configurationName"> Represents configuration name that uniquely identifies configuration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HierarchyInformation(string productFamilyName, string productLineName, string productName, string configurationName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProductFamilyName = productFamilyName;
            ProductLineName = productLineName;
            ProductName = productName;
            ConfigurationName = configurationName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Represents product family name that uniquely identifies product family. </summary>
        public string ProductFamilyName { get; set; }
        /// <summary> Represents product line name that uniquely identifies product line. </summary>
        public string ProductLineName { get; set; }
        /// <summary> Represents product name that uniquely identifies product. </summary>
        public string ProductName { get; set; }
        /// <summary> Represents configuration name that uniquely identifies configuration. </summary>
        public string ConfigurationName { get; set; }
    }
}
