// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Forward shipment details. </summary>
    public partial class ForwardShippingDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ForwardShippingDetails"/>. </summary>
        internal ForwardShippingDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ForwardShippingDetails"/>. </summary>
        /// <param name="carrierName"> Name of the carrier. </param>
        /// <param name="carrierDisplayName"> Carrier Name for display purpose. Not to be used for any processing. </param>
        /// <param name="trackingId"> TrackingId of the package. </param>
        /// <param name="trackingUri"> TrackingUrl of the package. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ForwardShippingDetails(string carrierName, string carrierDisplayName, string trackingId, Uri trackingUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CarrierName = carrierName;
            CarrierDisplayName = carrierDisplayName;
            TrackingId = trackingId;
            TrackingUri = trackingUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the carrier. </summary>
        public string CarrierName { get; }
        /// <summary> Carrier Name for display purpose. Not to be used for any processing. </summary>
        public string CarrierDisplayName { get; }
        /// <summary> TrackingId of the package. </summary>
        public string TrackingId { get; }
        /// <summary> TrackingUrl of the package. </summary>
        public Uri TrackingUri { get; }
    }
}
