// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Stage status. </summary>
    public readonly partial struct EdgeOrderStageStatus : IEquatable<EdgeOrderStageStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EdgeOrderStageStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EdgeOrderStageStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string InProgressValue = "InProgress";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CancelledValue = "Cancelled";
        private const string CancellingValue = "Cancelling";

        /// <summary> No status available yet. </summary>
        public static EdgeOrderStageStatus None { get; } = new EdgeOrderStageStatus(NoneValue);
        /// <summary> Stage is in progress. </summary>
        public static EdgeOrderStageStatus InProgress { get; } = new EdgeOrderStageStatus(InProgressValue);
        /// <summary> Stage has succeeded. </summary>
        public static EdgeOrderStageStatus Succeeded { get; } = new EdgeOrderStageStatus(SucceededValue);
        /// <summary> Stage has failed. </summary>
        public static EdgeOrderStageStatus Failed { get; } = new EdgeOrderStageStatus(FailedValue);
        /// <summary> Stage has been cancelled. </summary>
        public static EdgeOrderStageStatus Cancelled { get; } = new EdgeOrderStageStatus(CancelledValue);
        /// <summary> Stage is cancelling. </summary>
        public static EdgeOrderStageStatus Cancelling { get; } = new EdgeOrderStageStatus(CancellingValue);
        /// <summary> Determines if two <see cref="EdgeOrderStageStatus"/> values are the same. </summary>
        public static bool operator ==(EdgeOrderStageStatus left, EdgeOrderStageStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EdgeOrderStageStatus"/> values are not the same. </summary>
        public static bool operator !=(EdgeOrderStageStatus left, EdgeOrderStageStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EdgeOrderStageStatus"/>. </summary>
        public static implicit operator EdgeOrderStageStatus(string value) => new EdgeOrderStageStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EdgeOrderStageStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EdgeOrderStageStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
