// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Image for the product. </summary>
    public partial class EdgeOrderProductImageInformation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EdgeOrderProductImageInformation"/>. </summary>
        internal EdgeOrderProductImageInformation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EdgeOrderProductImageInformation"/>. </summary>
        /// <param name="imageType"> Type of the image. </param>
        /// <param name="imageUri"> Url of the image. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EdgeOrderProductImageInformation(EdgeOrderProductImageType? imageType, Uri imageUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ImageType = imageType;
            ImageUri = imageUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of the image. </summary>
        public EdgeOrderProductImageType? ImageType { get; }
        /// <summary> Url of the image. </summary>
        public Uri ImageUri { get; }
    }
}
