// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.EdgeOrder.Models
{
    /// <summary> Device details. </summary>
    public partial class EdgeOrderProductDeviceDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EdgeOrderProductDeviceDetails"/>. </summary>
        internal EdgeOrderProductDeviceDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EdgeOrderProductDeviceDetails"/>. </summary>
        /// <param name="serialNumber"> device serial number. </param>
        /// <param name="managementResourceId"> Management Resource Id. </param>
        /// <param name="managementResourceTenantId"> Management Resource Tenant ID. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EdgeOrderProductDeviceDetails(string serialNumber, string managementResourceId, string managementResourceTenantId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SerialNumber = serialNumber;
            ManagementResourceId = managementResourceId;
            ManagementResourceTenantId = managementResourceTenantId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> device serial number. </summary>
        public string SerialNumber { get; }
        /// <summary> Management Resource Id. </summary>
        public string ManagementResourceId { get; }
        /// <summary> Management Resource Tenant ID. </summary>
        public string ManagementResourceTenantId { get; }
    }
}
